// Help text array

var help_array = new Array();

help_array['force_default'] = "Force default setting allows you to force a characteristic to its default value. By default characteristics that are left to their default values, are not included to creature begindefinecreature code.<br />The following situation illustrates the problem:<br /><br />First we make a normal goblin.<pre>begindefinecreature 1;\n\tcr_name = \"Goblin\";\n\tcr_level = 5;\n\tcr_summon_class = 1;\n\t...</pre>Then we want to save time & code and create goblin boss using import.<pre>begindefinecreature 2;\n\timport = 1;\n\tcr_name = \"Unique goblin boss\";\n\tcr_level = 9;\n\tcr_summon_class = -1;</pre>Of course, we don't want that some lousy goblin wizard summons this unique boss, so cr_summon_class = -1; must be included.<br />If force default isn't set to 'Yes', creature editor removes the cr_summon_class = -1; line and user has to add it manually every time.";
help_array['cr_number'] = "Creature number is a unique identifier for each creature type.";
help_array['clear'] = "If clear is set to 'Yes', all creature's characteristics are set to their default values.";
help_array['import'] = "By specifying creature's number you can copy its characteristics.<pre>\nbegindefinecreature 110;\n\timport = 1;\n</pre>Would copy characteristics of creature number 1 (merchant). Characteristics include level, graphic sheet, etc.";
help_array['cr_name'] = "(no data)";
help_array['cr_default_script'] = "The name of the default script for the creature type.<br />Creature's script tells how the creature moves, acts and fights. Usually left at default value.";
help_array['cr_level'] = "Creature's level is the most important characteristic.<br />Level affects creature's hit points, spell points, strength, dexterity, intelligence, endurance and all weapon skills.";
help_array['cr_hp_bonus'] = "HP bonus is the number of extra hit points added to creature's base hit points. Base hit points are determined by creature's level.";
help_array['cr_sp_bonus'] = "SP bonus is the number of extra spell points added to creature's base spell points. NPC caster's spells use spell points as much as spell casters' in the party.";
help_array['cr_special_abil'] = "The special ability the creature has.<br />Special ability's strength depends on creature's level. If you are creating an ice drake for instance, perhaps it would be a good idea to give it cold breathing ability.";
help_array['cr_default_attitude'] = "Creature's attitude determines how it reacts to party.<br />Hostile A creatures will attack Hostile B ones, and vice versa.";
help_array['cr_species'] = "The species of the creature. The species can affect what attacks the creature is vulnerable to.<br /><pre>Human, humanoid, nephil, slith and giant species are vulnerable to attackers with Anatomy skill.\nThe spells Divine Retribution and Ravage Life only affect creatures of species human, humanoid, nephil, slith, giant, reptile or beast.\nNephils get bonus with missile weapons and dexterity.\nSliths get bonus with Pole Weapons and fire resistance.\nReptiles won't pick up or use items.\nBeasts won't pick up or use items.\nDemons won't pick up or use items, are vulnerable to Repel Spirit and immune to Mind Spells.\nUndead won't pick up or use items, are vulnerable to Repel Spirit and immune to Mind Spells.\nInsects won't pick up or use items, are immune to Mental Spells and immune to Webs.\nSlimes/plants won't pick up or use items and are immune to assasination and Mind spells.\nStones/golems won't pick up or use items and are immune to assasination and beams.\nSpecial are immune to assasination, lethal blow, simulacrum and webs.\n</pre>";
help_array['cr_natural_armor'] = "Natural armor represents the creature's natural damage resistance, eg. scales or tough skin.<br />Reduces melee damage by 1dn points, where n is equal to creature's natural armor. For example, a creature with natural armor of 5, takes 1 to 5 points less damage from a blow.";
help_array['cr_attack_n'] = "Innate attack gives creature an additional melee attack.<br />The damage of the attack is n<sub>1</sub>dn<sub>2</sub>, where n<sub>1</sub> is equal to creature's strength and n<sub>2</sub> equal to innate attack value.<br />For example creature with strength 10 and innate attack 5 would have base damage from 10 to 50 (10d5).<br />Innate attack also has a description, eg. the pile of goo slimes charName for 23 points of damage.";
help_array['cr_ap_bonus'] = "AP bonus is the number of extra action points added to creature's base action points.";
help_array['cr_default_strategy'] = "The default strategy affects how the creature acts in combat.";
help_array['cr_default_agression'] = "Creature's default agression affects the chance that creature will take a foe as a target and attack it.<br />Higher number will increase the chance. This also affects the distance that creature will notice foes. For example, a creature with agression of 50% won't notice foes from distance 1/2 farther than the script is set to.";
help_array['cr_default_courage'] = "Default courage is the percentage chance that the creature won't flee from combat when wounded.<br />The more damaged the character is, the more often it checks whether it flees. A character whose courage is 0 always flees.";

